/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.client.util;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.client.api.ClientPrePackRepository;
import io.github.lukebemish.dynamic_asset_generator.client.api.DynAssetGeneratorClientAPI;
import io.github.lukebemish.dynamic_asset_generator.client.util.IPalettePlan;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.resources.ResourceLocation;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class BuddingPalettePlan
implements IPalettePlan {
    private static final ResourceLocation FALLBACK_TEXTURE = BuddingPalettePlan.bcRl("textures/block/fallback.png");
    private static final ResourceLocation EMPTY_TEXTURE = BuddingPalettePlan.bcRl("textures/block/empty.png");
    private final ResourceLocation background;
    private final ResourceLocation paletted;

    private BuddingPalettePlan(ResourceLocation background, ResourceLocation paletted) {
        this.background = new ResourceLocation(background.m_135827_(), "textures/" + background.m_135815_() + ".png");
        this.paletted = new ResourceLocation(paletted.m_135827_(), "textures/" + paletted.m_135815_() + ".png");
    }

    public NativeImage getBackground() throws IOException {
        return BuddingPalettePlan.readImage(this.background);
    }

    public NativeImage getOverlay() throws IOException {
        return BuddingPalettePlan.readImage(EMPTY_TEXTURE);
    }

    public NativeImage getPaletted() throws IOException {
        return BuddingPalettePlan.readImage(this.paletted);
    }

    public boolean includeBackground() {
        return false;
    }

    public boolean stretchPaletted() {
        return true;
    }

    public int extend() {
        return 0;
    }

    public static void plan(CrystalSet set) {
        String name = set.getName();
        BuddingPalettePlan.plan("block/budding/" + name, new BuddingPalettePlan(set.isActive() ? set.getBuddingSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlan.mcRl("block/budding_amethyst")));
        BuddingPalettePlan.plan("block/small_bud/" + name, new BuddingPalettePlan(set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlan.mcRl("block/small_amethyst_bud")));
        BuddingPalettePlan.plan("block/medium_bud/" + name, new BuddingPalettePlan(set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlan.mcRl("block/medium_amethyst_bud")));
        BuddingPalettePlan.plan("block/large_bud/" + name, new BuddingPalettePlan(set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlan.mcRl("block/large_amethyst_bud")));
        BuddingPalettePlan.plan("block/cluster/" + name, new BuddingPalettePlan(set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlan.mcRl("block/amethyst_cluster")));
    }

    public static void planCatalyst() {
        BuddingPalettePlan.plan("item/crystal_catalyst", new BuddingPalettePlan(BuddingPalettePlan.mcRl("item/amethyst_shard"), BuddingPalettePlan.mcRl("item/blaze_powder")));
    }

    private static void plan(String path, BuddingPalettePlan plan) {
        DynAssetGeneratorClientAPI.planPaletteCombinedImage((ResourceLocation)BuddingPalettePlan.bcRl("textures/" + path + ".png"), (IPalettePlan)plan);
    }

    private static NativeImage readImage(ResourceLocation location) throws IOException {
        return NativeImage.m_85058_((InputStream)ClientPrePackRepository.getResource((ResourceLocation)location));
    }

    private static ResourceLocation bcRl(String path) {
        return BuddingPalettePlan.rl("buddingcrystals", path);
    }

    private static ResourceLocation mcRl(String path) {
        return BuddingPalettePlan.rl("minecraft", path);
    }

    private static ResourceLocation rl(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }
}

